% SMAS estimation of price stickiness as in Guerron-Quintana et al. (2017)
% model (robustness check)

clear all;
load('sampledataT232');
rng('default')
rng('shuffle')

%dynare dgp;

sampledata = sampledataT232(:, :, 1001:1030);
[d, T, s] = size(sampledata);

B = 20;
valid = 0;

global p h;
p = 2;
h = 80;
hs = 1;
true_alpha=0.75;

v_est_alpha = zeros(B, 1);
v_est_alpha_reg = zeros(B, 1);
v_est_alpha_nonreg = zeros(B, 1);
v_est_alpha_opt_reg = zeros(B, 1);
v_est_alpha_opt_nonreg = zeros(B, 1);
v_est_alpha_opt = zeros(B, 1);
v_est_alpha_diag = zeros(B, 1);
v_pick_c_1 = zeros(B, 1);

% set the range of grid search
alphas = 0.005:0.005:0.995;

% vector of candidate alpha values
c_a = [2 1 0.5 0.1 0.05 0.01 0.005 0.001 0.0001];

N = 199;
trainingT = round(2/3*T);
training = sampledata(:, 1:trainingT, :);
testing = sampledata(:, trainingT+1:T, :);
ST = ceil(0.75*(T^(1/3)));
ST_training = ceil(0.75*(trainingT^(1/3)));

% estimate with training sample
for i = 1:s
    tic
    aaa = i
    valid
    if valid < B
    try % if anything wrong, skip to next sample
    % training irf
    v_sampledata = training(:, :, i);
    %solve for a VAR(p) model
    [A,SIGMA,U,V] = olsvarc(v_sampledata', p);
    sampleirf = vec(irfvar(A,SIGMA,p)); % structural irfs generated for this simulated path with true alpha, not vectorized
    
    %testing irf
    v_sampletest = testing(:, :, i);
    [At,SIGMAt,Ut,Vt] = olsvarc(v_sampletest', p);
    testirf = vec(irfvar(At,SIGMAt,p));

    %full sample irf
    v_sampledata_full = sampledata(:, :, i); 
    [Af,SIGMAf,Uf,Vf] = olsvarc(v_sampledata_full', p);
    sampleirf_full = vec(irfvar(Af,SIGMAf,p));
    
    irfs = zeros(4*(h+1), length(alphas));
    M_lambda = zeros(N,N,length(alphas));
    M_phi = zeros((h-hs+1)*4,N,length(alphas));
    M_lambda_opt = zeros(N,N,length(alphas));
    M_phi_opt = zeros((h-hs+1)*4,N,length(alphas));
    first_time = 1;

    for m=1:length(alphas)
%     for m=6;
%       try
        if first_time
        
            dynare dgptest_rb noclearall;
            [sim_array]=get_simul_replications(M_,options_); 
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            first_time = 0;
        else
            set_param_value('alpha',alphas(m));
            [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
            [sim_array]=get_simul_replications(M_,options_);
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
        end
        
        simdata = sim_array([1 2],1001:(1000 + trainingT), :);

%-------alpha dependent operator--------%
        simdata_star = simdata;
        irf_star = zeros(4, (h+1), N);
        v_irf_star = zeros(4*(h+1), N);
        irf_star_1a = zeros(4, (h+1), N);
        irf_star_1b = zeros(4, (h+1), N);
        irf_star_2a = zeros(4, (h+1), N);
        irf_star_2b = zeros(4, (h+1), N);
        irf_star_3a = zeros(4, (h+1), N);
        irf_star_3b = zeros(4, (h+1), N);
        irf_star_4a = zeros(4, (h+1), N);
        irf_star_4b = zeros(4, (h+1), N);
        irf_star_5a = zeros(4, (h+1), N);
        irf_star_5b = zeros(4, (h+1), N);
        valid_C1 = 0;
        n=1;
        while valid_C1 < N
            try
            IRFii_ST = zeros(4,(h+1),ST_training*2);
            yy = simdata_star(:,:,n)';
            [Ast,SIGMAst,Ust,Vst] = olsvarc(yy, p);
            IRFii = irfvar(Ast,SIGMAst,p);
%             [IRFii]=bootirf(A,U,v_sampledata',V);
            irf_star(:, :, valid_C1+1) = IRFii;% store the values
            v_irf_star(:, valid_C1+1) = vec(IRFii);
            for j = 1:ST_training
                y1 = yy(1:trainingT-j,:);
                [Ast1,SIGMAst1,Ust1,Vst1] = olsvarc(y1, p);
                if ~ any(abs(eig(Ast1))>=1)
                    [Ast1]=asybc(Ast1,SIGMAst1,trainingT-j,p);
                end;
                [IRFii_a] = irfvar(Ast1,SIGMAst1,p);
                IRFii_ST(:,:,2*j-1)=IRFii_a;
                
                y2 = yy(j+1:trainingT,:);
                [Ast2,SIGMAst2,Ust2,Vst2]=olsvarc(y2,p);

                if ~ any(abs(eig(Ast2))>=1)
                    [Ast2]=asybc(Ast2,SIGMAst2,trainingT-j,p);
                end;

                [IRFii_b]=irfvar(Ast2,SIGMAst2,p);
                IRFii_ST(:,:,2*j)=IRFii_b;
            end
        
            valid_C1 = valid_C1+1;
            irf_star_1a(:,:,valid_C1) = IRFii_ST(:,:,1);
            irf_star_1b(:,:,valid_C1) = IRFii_ST(:,:,2);
            irf_star_2a(:,:,valid_C1) = IRFii_ST(:,:,3);
            irf_star_2b(:,:,valid_C1) = IRFii_ST(:,:,4);
            irf_star_3a(:,:,valid_C1) = IRFii_ST(:,:,5);
            irf_star_3b(:,:,valid_C1) = IRFii_ST(:,:,6);
            irf_star_4a(:,:,valid_C1) = IRFii_ST(:,:,7);
            irf_star_4b(:,:,valid_C1) = IRFii_ST(:,:,8);
            irf_star_5a(:,:,valid_C1) = IRFii_ST(:,:,9);
            irf_star_5b(:,:,valid_C1) = IRFii_ST(:,:,10);
            catch
                valid_C1 = valid_C1;
            end
            n=n+1;
        end
        NN=n;
        mean_irf_star = mean(v_irf_star, 2); % calculate the mean of irf from N paths
        demean_irf_star = irf_star-mean(irf_star,3);
        demean_irf_star_1a = irf_star_1a-mean(irf_star_1a,3);
        demean_irf_star_1b = irf_star_1b-mean(irf_star_1b,3);
        demean_irf_star_2a = irf_star_2a-mean(irf_star_2a,3);
        demean_irf_star_2b = irf_star_2b-mean(irf_star_2b,3);
        demean_irf_star_3a = irf_star_3a-mean(irf_star_3a,3);
        demean_irf_star_3b = irf_star_3b-mean(irf_star_3b,3);
        demean_irf_star_4a = irf_star_4a-mean(irf_star_4a,3);
        demean_irf_star_4b = irf_star_4b-mean(irf_star_4b,3);
        demean_irf_star_5a = irf_star_5a-mean(irf_star_5a,3);
        demean_irf_star_5b = irf_star_5b-mean(irf_star_5b,3);
    
        C = zeros(N, N);
        C_opt = zeros(N, N);
        
        for b = 1:N
            for bprime = 1:N
                Cbb = 0;
                Cbb_opt = 0;
                for ss = hs: h
                    Cbb = Cbb + demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)/N;
                    Cbb_opt = Cbb_opt...
                        + (demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)...
                        + 2*((1-1/ST_training)*demean_irf_star_1a(:,ss+1,b)'*demean_irf_star_1b(:,ss+1,bprime)...
                        +(1-2/ST_training)*demean_irf_star_2a(:,ss+1,b)'*demean_irf_star_2b(:,ss+1,bprime)...
                        +(1-3/ST_training)*demean_irf_star_3a(:,ss+1,b)'*demean_irf_star_3b(:,ss+1,bprime)...
                        +(1-4/ST_training)*demean_irf_star_4a(:,ss+1,b)'*demean_irf_star_4b(:,ss+1,bprime)...
                        +(1-5/ST_training)*demean_irf_star_5a(:,ss+1,b)'*demean_irf_star_5b(:,ss+1,bprime)))/N;
                end
                C(b, bprime) = Cbb;
                C_opt(b, bprime) = Cbb_opt;
            end
        end
        
        [Beta lambda] = eig(C);

        lambda = diag(lambda);
        correction = abs(lambda)<10^(-8);
        lambda(correction)=0;
        eigenvectors = Beta;
        eigenvectors(:,correction)=0;
        I=eye(N); 
        adjustv=zeros(N,1);
        adjustv(N)=1;
        if sum(lambda<0)>0
            [UU, S, VV] = svd(C);
            lambda = diag(S);
            eigenvectors=zeros(N,N);
            for i = 1:length(lambda);
                shiftedM = C-lambda(i)*I;
                rrefv = rref(shiftedM);
                eigv = -rrefv(:,N)+adjustv;
                eigv = eigv/norm(eigv);
                eigenvectors(:,i) = eigv;
            end
        end
        lambda=diag(lambda);
        Beta=eigenvectors;
        M_lambda(:,:,m) = lambda;
        psi = v_irf_star((4*hs + 1):4*(h+1), :) - mean_irf_star((4*hs+1):4*(h+1));
    
        phi = psi * Beta/N;
    
        % normalize phi
    
        phi = (phi'./sqrt(diag(phi' * phi)))';
        phi(isnan(phi))=0;
        M_phi(:,:,m)=phi;
        
        [Beta_opt lambda_opt] = eig(C_opt);
        lambda_opt = diag(lambda_opt);
        correction = abs(lambda_opt)<10^(-8);
        lambda_opt(correction)=0;
        eigenvectors = Beta_opt;
        eigenvectors(:,correction)=0;

        lambda_opt=diag(lambda_opt);
        Beta_opt=eigenvectors;
        M_lambda_opt(:,:,m) = lambda_opt;
        psi_opt = demean_irf_star+2*((1-1/ST_training)*demean_irf_star_1a...
                            +(1-2/ST_training)*demean_irf_star_2a...
                            +(1-3/ST_training)*demean_irf_star_3a...
                            +(1-4/ST_training)*demean_irf_star_4a...
                            +(1-5/ST_training)*demean_irf_star_5a);
        psi_opt = reshape(psi_opt, 4*(h+1), N);
        psi_opt = psi_opt((4*hs + 1):4*(h+1), :);
        phi_opt = psi_opt * Beta_opt/N;
        % normalize phi
        phi_opt = (phi_opt'./sqrt(diag(phi_opt' * phi_opt)))';
        phi_opt(isnan(phi_opt))=0;
        M_phi_opt(:,:,m)=phi_opt;
                
        m_irf_path = zeros(4*(h+1), 10);
        count = 1;
        j = 1;
            
        while count < 11
            try
            simdata_path = simdata(:, :, NN+j);% extract one path
            [Apath,SIGMApath,Upath,Vpath] = olsvarc(simdata_path', p);
            [IRFr]=bootirf(Apath,U,v_sampledata',Vpath);
            % to construct irfs with residual bootstrapping, we use
            % estimation of Vpath(intercept) and Apath(coefficient
            % matrix) using simulation with selected value of alpha
            % U(residuals) computed from true data
            % initial values are randomly chosen from true data
            irf_path = vec(IRFr); %vectorize IRFr
            m_irf_path(:, count) = irf_path;% store the values
            count = count + 1;
            catch
                count = count;
            end
            j = j+1;
        end

        mean_irf = sum(m_irf_path, 2)/10; % calculate the mean of ir by the third dimension, with each alpha
        irfs(:, m) = mean_irf; % store the values, as irfs for the alpha
    end
    
    dis = sampleirf((4*hs+1):4*(h+1)) - irfs((4*hs+1):4*(h+1), :); 
    dis_sqr = sum(dis.^2, 1);
    % loop over reg_a's.
    % get values of the objective function associated with each reg_a
    
    reg_a = c_a./(trainingT^(1/3));
    v_obj = zeros(length(alphas), 1);
    v_d_sqr_1 = zeros(length(reg_a), 1);
    
    v_obj_opt = zeros(length(alphas), 1);
    v_d_sqr_2 = zeros(length(reg_a), 1);
    
    for aa = 1:length(reg_a)
        for m = 1: length(alphas)
            reg_dis = dis(:, m);
            reg_sqr = (M_phi(:,:,m)' * reg_dis).^2; % T by 1 vector
            obj = (diag(M_lambda(:,:,m))./(diag(M_lambda(:,:,m)).^2 + reg_a(aa)))' * reg_sqr;
            v_obj(m) = obj;
            
            reg_sqr_opt = (M_phi_opt(:,:,m)' * reg_dis).^2; % T by 1 vector
            obj_opt = (diag(M_lambda_opt(:,:,m))./(diag(M_lambda_opt(:,:,m)).^2 + reg_a(aa)))' * reg_sqr_opt;
            v_obj_opt(m) = obj_opt;
        end
    
        est_alpha_reg = alphas*(v_obj == min(v_obj));

        set_param_value('alpha',est_alpha_reg); % update alpha, get the simulation
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

        simtesting = sim_array([1 2],(1001+trainingT):(1000+T), randi([1 500],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);
            
        m_irf_testing_1 = zeros(4*(h+1), 10);

            for tt = 1:10
                [IRFt1]=bootirf(Atest,Ut,v_sampletest',Vtest);
                m_irf_testing_1(:, tt) = vec(IRFt1);% store the values
            end

        mean_irf_testing_1 = mean(m_irf_testing_1,2);
        d_sqr_1 = (testirf((4*hs+1):4*(h+1)) - mean_irf_testing_1((4*hs+1):4*(h+1)))'...
            *(testirf((4*hs+1):4*(h+1)) - mean_irf_testing_1((4*hs+1):4*(h+1)));
        v_d_sqr_1(aa) = d_sqr_1;
        
    % optimal SMAS
        est_alpha_reg_opt = alphas*(v_obj_opt == min(v_obj_opt));

        set_param_value('alpha',est_alpha_reg_opt); % update alpha, get the simulation
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

        simtesting = sim_array([1 2],(1001+trainingT):(1000+T), randi([1 500],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);
            
        m_irf_testing_2 = zeros(4*(h+1), 10);

            for tt = 1:10
                [IRFt2]=bootirf(Atest,Ut,v_sampletest',Vtest);
                m_irf_testing_2(:, tt) = vec(IRFt2);% store the values
            end

        mean_irf_testing_2 = mean(m_irf_testing_2,2);
        d_sqr_2 = (testirf((4*hs+1):4*(h+1)) - mean_irf_testing_2((4*hs+1):4*(h+1)))'...
            *(testirf((4*hs+1):4*(h+1)) - mean_irf_testing_2((4*hs+1):4*(h+1)));
        v_d_sqr_2(aa) = d_sqr_2;
    end
    
    pick_c_1 = c_a*(v_d_sqr_1 == min(v_d_sqr_1));
    v_pick_c_1(i) = pick_c_1;
    pick_c_2 = c_a*(v_d_sqr_2 == min(v_d_sqr_2));
    v_pick_c_2(i) = pick_c_2;
    
    irfs_full = zeros(4*(h+1), length(alphas));
    first_time = 1;

    for m=1:length(alphas)
        if first_time 
            dynare dgptest_rb noclearall; 
            [sim_array]=get_simul_replications(M_,options_); 
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            first_time = 0;
        else
            set_param_value('alpha',alphas(m)); 
            [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
            [sim_array]=get_simul_replications(M_,options_);
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
        end
        
        simdata_alpha = sim_array([1 2],1001:(1000+T), :);
        
        %-------alpha dependent operator--------%
        simdata_star_f = simdata_alpha;
        irf_star_f = zeros(4, (h+1), N);
        v_irf_star_f = zeros(4*(h+1), N);
        irf_star_f_1a = zeros(4, (h+1), N);
        irf_star_f_1b = zeros(4, (h+1), N);
        irf_star_f_2a = zeros(4, (h+1), N);
        irf_star_f_2b = zeros(4, (h+1), N);
        irf_star_f_3a = zeros(4, (h+1), N);
        irf_star_f_3b = zeros(4, (h+1), N);
        irf_star_f_4a = zeros(4, (h+1), N);
        irf_star_f_4b = zeros(4, (h+1), N);
        irf_star_f_5a = zeros(4, (h+1), N);
        irf_star_f_5b = zeros(4, (h+1), N);
        
        valid_C2 = 0;
        n = 1;
        while valid_C2 < N
            try
            IRFii_ST = zeros(4,(h+1),ST*2);
            yy = simdata_star_f(:,:,n)';
            [Ast_f,SIGMAst_f,Ust_f,Vst_f] = olsvarc(yy, p);
            IRFii_f = irfvar(Ast_f,SIGMAst_f,p);
%             [IRFii]=bootirf(A,U,v_sampledata',V);
            irf_star_f(:, :, valid_C2+1) = IRFii_f;% store the values
            v_irf_star_f(:, valid_C2+1) = vec(IRFii_f);
            for j = 1:ST
                y1 = yy(1:T-j,:);
                [Ast1,SIGMAst1,Ust1,Vst1] = olsvarc(y1, p);
                if ~ any(abs(eig(Ast1))>=1)
                    [Ast1]=asybc(Ast1,SIGMAst1,T-j,p);
                end;
                [IRFii_a] = irfvar(Ast1,SIGMAst1,p);
                IRFii_ST(:,:,2*j-1)=IRFii_a;
                
                y2 = yy(j+1:T,:);
                [Ast2,SIGMAst2,Ust2,Vst2]=olsvarc(y2,p);

                if ~ any(abs(eig(Ast2))>=1)
                    [Ast2]=asybc(Ast2,SIGMAst2,T-j,p);
                end;

                [IRFii_b]=irfvar(Ast2,SIGMAst2,p);
                IRFii_ST(:,:,2*j)=IRFii_b;
            end
            valid_C2 = valid_C2+1;
            irf_star_f_1a(:,:,valid_C2) = IRFii_ST(:,:,1);
            irf_star_f_1b(:,:,valid_C2) = IRFii_ST(:,:,2);
            irf_star_f_2a(:,:,valid_C2) = IRFii_ST(:,:,3);
            irf_star_f_2b(:,:,valid_C2) = IRFii_ST(:,:,4);
            irf_star_f_3a(:,:,valid_C2) = IRFii_ST(:,:,5);
            irf_star_f_3b(:,:,valid_C2) = IRFii_ST(:,:,6);
            irf_star_f_4a(:,:,valid_C2) = IRFii_ST(:,:,7);
            irf_star_f_4b(:,:,valid_C2) = IRFii_ST(:,:,8);
            irf_star_f_5a(:,:,valid_C2) = IRFii_ST(:,:,9);
            irf_star_f_5b(:,:,valid_C2) = IRFii_ST(:,:,10);
            catch
                valid_C2=valid_C2;
            end
            n=n+1;
        end
        NN=n;
        mean_irf_star_f = mean(v_irf_star_f, 2); % calculate the mean of irf from N paths
        demean_irf_star_f = irf_star_f-mean(irf_star_f,3);
        
        demean_irf_star_f_1a = irf_star_f_1a-mean(irf_star_f_1a,3);
        demean_irf_star_f_1b = irf_star_f_1b-mean(irf_star_f_1b,3);
        demean_irf_star_f_2a = irf_star_f_2a-mean(irf_star_f_2a,3);
        demean_irf_star_f_2b = irf_star_f_2b-mean(irf_star_f_2b,3);
        demean_irf_star_f_3a = irf_star_f_3a-mean(irf_star_f_3a,3);
        demean_irf_star_f_3b = irf_star_f_3b-mean(irf_star_f_3b,3);
        demean_irf_star_f_4a = irf_star_f_4a-mean(irf_star_f_4a,3);
        demean_irf_star_f_4b = irf_star_f_4b-mean(irf_star_f_4b,3);
        demean_irf_star_f_5a = irf_star_f_5a-mean(irf_star_f_5a,3);
        demean_irf_star_f_5b = irf_star_f_5b-mean(irf_star_f_5b,3);
    
        Cf = zeros(N, N);
        Cf_opt = zeros(N, N);
        
        for b = 1:N
            for bprime = 1:N
                Cbb_f = 0;
                Cbb_f_opt = 0;
                for ss = hs: h
                    Cbb_f = Cbb_f + demean_irf_star_f(:, ss+1, b)'...
                    * demean_irf_star_f(:, ss+1, bprime)/N;
                Cbb_f_opt = Cbb_f_opt...
                    + (demean_irf_star_f(:, ss+1, b)'* demean_irf_star_f(:, ss+1, bprime)...
                    + 2*((1-1/ST)*demean_irf_star_f_1a(:,ss+1,b)'*demean_irf_star_f_1b(:,ss+1,bprime)...
                        +(1-2/ST)*demean_irf_star_f_2a(:,ss+1,b)'*demean_irf_star_f_2b(:,ss+1,bprime)...
                        +(1-3/ST)*demean_irf_star_f_3a(:,ss+1,b)'*demean_irf_star_f_3b(:,ss+1,bprime)...
                        +(1-4/ST)*demean_irf_star_f_4a(:,ss+1,b)'*demean_irf_star_f_4b(:,ss+1,bprime)...
                        +(1-5/ST)*demean_irf_star_f_5a(:,ss+1,b)'*demean_irf_star_f_5b(:,ss+1,bprime)))/N;
                end
                Cf(b, bprime) = Cbb_f;
                Cf_opt(b, bprime) = Cbb_f_opt;
            end
        end
        [Beta_f lambda_f] = eig(Cf);
        lambda_f = diag(lambda_f);
        correction = abs(lambda_f)<10^(-8);
        lambda_f(correction)=0;
        eigenvectors = Beta_f;
        eigenvectors(:,correction)=0;
        I=eye(N); 
        adjustv=zeros(N,1);
        adjustv(N)=1;
        if sum(lambda_f<0)>0
            [UU, S, VV] = svd(Cf);
            lambda_f = diag(S);
            eigenvectors=zeros(N,N);
            for i = 1:length(lambda_f);
                shiftedM = Cf-lambda_f(i)*I;
                rrefv = rref(shiftedM);
                eigv = -rrefv(:,N)+adjustv;
                eigv = eigv/norm(eigv);
                eigenvectors(:,i) = eigv;
            end
        end
        lambda_f=diag(lambda_f);
        Beta_f=eigenvectors;
%         M_lambda(:,:,m) = lambda;
        psi_f = v_irf_star_f((4*hs + 1):4*(h+1), :) - mean_irf_star_f((4*hs+1):4*(h+1));
    
        phi_f = psi_f * Beta_f/N;
    
        % normalize phi
    
        phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
        phi_f(isnan(phi_f))=0;
        
        [Beta_f_opt lambda_f_opt] = eig(Cf_opt);
        lambda_f_opt = diag(lambda_f_opt);
        correction = abs(lambda_f_opt)<10^(-8);
        lambda_f_opt(correction)=0;
        eigenvectors = Beta_f_opt;
        eigenvectors(:,correction)=0;
%         I=eye(N); 
%         adjustv=zeros(N,1);
%         adjustv(N)=1;
%         if sum(lambda_f_opt<0)>0
%             [UU, S, VV] = svd(Cf_opt);
%             lambda_f_opt = diag(S);
%             eigenvectors=zeros(N,N);
%             for i = 1:length(lambda_f_opt);
%                 shiftedM = Cf_opt-lambda_f_opt(i)*I;
%                 rrefv = rref(shiftedM);
%                 eigv = -rrefv(:,N)+adjustv;
%                 eigv = eigv/norm(eigv);
%                 eigenvectors(:,i) = eigv;
%             end
%         end
        lambda_f_opt=diag(lambda_f_opt);
        Beta_f_opt=eigenvectors;
%         M_lambda(:,:,m) = lambda;
        psi_f = v_irf_star_f((4*hs + 1):4*(h+1), :) - mean_irf_star_f((4*hs+1):4*(h+1));
    
        phi_f = psi_f * Beta_f/N;
    
        % normalize phi
    
        phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
        phi_f(isnan(phi_f))=0;
        
        psi_f_opt = demean_irf_star_f+2*((1-1/ST)*demean_irf_star_f_1a...
                            +(1-2/ST)*demean_irf_star_f_2a...
                            +(1-3/ST)*demean_irf_star_f_3a...
                            +(1-4/ST)*demean_irf_star_f_4a...
                            +(1-5/ST)*demean_irf_star_f_5a);
        psi_f_opt = reshape(psi_f_opt, 4*(h+1), N);
        psi_f_opt = psi_f_opt((4*hs + 1):4*(h+1), :);
        phi_f_opt = psi_f_opt * Beta_f_opt/N;
        % normalize phi
        phi_f_opt = (phi_f_opt'./sqrt(diag(phi_f_opt' * phi_f_opt)))';
        phi_f_opt(isnan(phi_f_opt))=0;
        
        
        m_irf_path_full = zeros(4*(h+1), 10);
        count = 1;
        j = 1;
        while count < 11
            try
            simdata_path_full = simdata_alpha(:, :, NN+j);
            [Apathf,SIGMApathf,Upathf,Vpathf] = olsvarc(simdata_path_full', p);
            [IRFr_full]=bootirf(Apathf,Uf,v_sampledata_full',Vpathf);
            irf_path_f = vec(IRFr_full);
            m_irf_path_f(:, count) = irf_path_f;
            count = count + 1;
            catch
                count = count;
            end
            j = j+1;
        end
        mean_irf_f = sum(m_irf_path_f, 2)/10; 
        irfs_full(:, m) = mean_irf_f;
    end
    
    dis_full = sampleirf_full((4*hs+1):4*(h+1)) - irfs_full((4*hs+1):4*(h+1), :); % dim: drop the first four responses
    dis_full_sqr = sum(dis_full.^2, 1);
    % find the min index and the corresponding phi
    est_alpha = alphas*(dis_full_sqr == min(dis_full_sqr))'
    v_est_alpha(i) = est_alpha;
    
    v_obj_1 = zeros(length(alphas), 1);
    v_obj_2 = zeros(length(alphas), 1);
    
    v_obj_opt_1 = zeros(length(alphas), 1);
    v_obj_opt_2 = zeros(length(alphas), 1);
    
    pick_reg_a_1 = pick_c_1/(T^(1/3));
    pick_reg_a_2 = pick_c_2/(T^(1/3));
    
%     pick_reg_a_1 = pick_c_1/(T^(1/3));
    
    for m = 1: length(alphas)
        reg_dis_full = dis_full(:, m);
        reg_sqr_full = (phi_f' * reg_dis_full).^2; % T by 1 vector
        obj_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * reg_sqr_full;
        obj_2 = (1/diag(lambda_f)) * reg_sqr_full;
        v_obj_1(m) = obj_1;
        v_obj_2(m) = obj_2;     
        
        reg_sqr_full_opt = (phi_f_opt' * reg_dis_full).^2; % T by 1 vector
        obj_opt_1 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * reg_sqr_full_opt;
        obj_opt_2 = (1/diag(lambda_f_opt)) * reg_sqr_full_opt;
        v_obj_opt_1(m) = obj_opt_1;
        v_obj_opt_2(m) = obj_opt_2;
    end
    
    est_alpha_reg = alphas*(v_obj_1 == min(v_obj_1))
    est_alpha_nonreg = alphas*(v_obj_2 == min(v_obj_2))
    est_alpha_opt_reg = alphas*(v_obj_opt_1 == min(v_obj_opt_1))
    est_alpha_opt_nonreg = alphas*(v_obj_opt_2 == min(v_obj_opt_2))

    v_est_alpha_reg(i) = est_alpha_reg;
    v_est_alpha_nonreg(i) = est_alpha_nonreg;
    v_est_alpha_opt_reg(i) = est_alpha_opt_reg;
    v_est_alpha_opt_nonreg(i) = est_alpha_opt_nonreg;
    
%     dis_sqr_opt = dis_full' * (pinv(W_opt_inv)*dis_full);
%     sqrnorm_opt = diag(dis_sqr_opt);
%     est_alpha_opt = alphas*(sqrnorm_opt == min(sqrnorm_opt))
%     v_est_alpha_opt(i) = est_alpha_opt;
% 
%     dis_sqr_diag = dis' * (W_diag_inv\dis);
%     sqrnorm_diag = diag(dis_sqr_diag);
%     est_alpha_diag = alphas*(sqrnorm_diag == min(sqrnorm_diag))
%     v_est_alpha_diag(i) = est_alpha_diag;
    
    valid = valid +1;
    catch
        disp('sample failed')
        valid = valid;
    end
    end
    toc
end

v_est_alpha = nonzeros(v_est_alpha);
v_est_alpha_reg = nonzeros(v_est_alpha_reg);
v_est_alpha_nonreg = nonzeros(v_est_alpha_nonreg);
v_est_alpha_opt_reg = nonzeros(v_est_alpha_opt_reg);
v_est_alpha_opt_nonreg = nonzeros(v_est_alpha_opt_nonreg);

v_pick_c_1 = nonzeros(v_pick_c_1);
v_pick_c_2 = nonzeros(v_pick_c_2);

mid = B/2;

std_alpha_1 = std(v_est_alpha(1:mid));
std_alpha_2 = std(v_est_alpha(mid+1:B));

std_alpha_reg_1 = std(v_est_alpha_reg(1:mid));
std_alpha_reg_2 = std(v_est_alpha_reg(mid+1:B));

std_alpha_nonreg_1 = std(v_est_alpha_nonreg(1:mid));
std_alpha_nonreg_2 = std(v_est_alpha_nonreg(mid+1:B));

std_alpha_opt_reg_1 = std(v_est_alpha_opt_reg(1:mid));
std_alpha_opt_reg_2 = std(v_est_alpha_opt_reg(mid+1:B));

std_alpha_opt_nonreg_1 = std(v_est_alpha_opt_nonreg(1:mid));
std_alpha_opt_nonreg_2 = std(v_est_alpha_opt_nonreg(mid+1:B));

ncover_noweight_5 = coverage(std_alpha_2, 0.05, v_est_alpha(1:mid), true_alpha) ...
                    + coverage(std_alpha_1, 0.05, v_est_alpha(mid+1:B), true_alpha)
                
ncover_noweight_10 = coverage(std_alpha_2, 0.1, v_est_alpha(1:mid), true_alpha) ...
                    + coverage(std_alpha_1, 0.1, v_est_alpha(mid+1:B), true_alpha)

ncover_reg_5 = coverage(std_alpha_reg_2, 0.05, v_est_alpha_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_reg_1, 0.05, v_est_alpha_reg(mid+1:B), true_alpha)
                
ncover_reg_10 = coverage(std_alpha_reg_2, 0.1, v_est_alpha_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_reg_1, 0.1, v_est_alpha_reg(mid+1:B), true_alpha)
                
ncover_nonreg_5 = coverage(std_alpha_nonreg_2, 0.05, v_est_alpha_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_nonreg_1, 0.05, v_est_alpha_nonreg(mid+1:B), true_alpha)
                
ncover_nonreg_10 = coverage(std_alpha_nonreg_2, 0.1, v_est_alpha_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_nonreg_1, 0.1, v_est_alpha_nonreg(mid+1:B), true_alpha)

ncover_opt_reg_5 = coverage(std_alpha_opt_reg_2, 0.05, v_est_alpha_opt_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_reg_1, 0.05, v_est_alpha_opt_reg(mid+1:B), true_alpha)
                
ncover_opt_reg_10 = coverage(std_alpha_opt_reg_2, 0.1, v_est_alpha_opt_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_reg_1, 0.1, v_est_alpha_opt_reg(mid+1:B), true_alpha)
                
ncover_opt_nonreg_5 = coverage(std_alpha_opt_nonreg_2, 0.05, v_est_alpha_opt_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_nonreg_1, 0.05, v_est_alpha_opt_nonreg(mid+1:B), true_alpha)
                
ncover_opt_nonreg_10 = coverage(std_alpha_opt_nonreg_2, 0.1, v_est_alpha_opt_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_nonreg_1, 0.1, v_est_alpha_opt_nonreg(mid+1:B), true_alpha)

mean_est_alpha = mean(v_est_alpha);
mean_est_alpha_reg = mean(v_est_alpha_reg);
mean_est_alpha_nonreg = mean(v_est_alpha_nonreg);
mean_est_alpha_opt_reg = mean(v_est_alpha_opt_reg);
mean_est_alpha_opt_nonreg = mean(v_est_alpha_opt_nonreg);

sd_est_alpha = std(v_est_alpha);
sd_est_alpha_reg = std(v_est_alpha_reg);
sd_est_alpha_nonreg = std(v_est_alpha_nonreg);
sd_est_alpha_opt_reg = std(v_est_alpha_opt_reg);
sd_est_alpha_opt_nonreg = std(v_est_alpha_opt_nonreg);

                
save T232p2H80_opt_rb_supple v_est_alpha v_est_alpha_reg v_est_alpha_nonreg... 
    v_est_alpha_opt_reg v_est_alpha_opt_nonreg...
    mean_est_alpha mean_est_alpha_reg mean_est_alpha_nonreg...
    mean_est_alpha_opt_reg mean_est_alpha_opt_nonreg...
    sd_est_alpha sd_est_alpha_reg sd_est_alpha_nonreg...
    sd_est_alpha_opt_reg sd_est_alpha_opt_nonreg...
    ncover_noweight_5 ncover_noweight_10 ncover_reg_5 ncover_reg_10... 
    ncover_nonreg_5 ncover_nonreg_10...
    ncover_opt_reg_5 ncover_opt_reg_10 ncover_opt_nonreg_5...
    ncover_opt_nonreg_10 v_pick_c_1 v_pick_c_2

